import cv2
import numpy as np  


def sharpness_detection_per_image(image_path):
	img = cv2.imread(image_path)
	
	#img = cv2.cv.LoadImage(image,CV_LOAD_IMAGE_COLOR)
	(height, width, depth) = img.shape

	ddepth = cv2.CV_16S
	#cv2.cv.SetImageROI
	sub_image = img[height/2:height/2+ height/3, width/3:width/3*2]

	gray = cv2.cvtColor(sub_image, cv2.COLOR_RGB2GRAY)
	#cv2.imshow('img',sub_image) 

	grad_x = cv2.Sobel(gray,ddepth,1,0,ksize = 3, scale = 1, delta = 0,borderType = cv2.BORDER_DEFAULT)
	grad_y = cv2.Sobel(gray,ddepth,0,1,ksize = 3, scale = 1, delta = 0, borderType = cv2.BORDER_DEFAULT)
	#print grad_x[0]
	size = sub_image.shape
	# abs_grad_x = np.zeros(size, dtype=np.uint8)
	# abs_grad_x = cv2.convertScaleAbs(grad_x,abs_grad_x, 1.0, 0.0)   # uint8
	abs_grad_x = cv2.convertScaleAbs(grad_x)
	abs_grad_y = cv2.convertScaleAbs(grad_y)

	grad = cv2.addWeighted(abs_grad_x,0.5,abs_grad_y,0.5,0)
	#print dst[0]
	cv2.waitKey(0)
	cv2.destroyAllWindows()

	cumsum = float(cv2.sumElems(grad)[0])/(sub_image.shape[1])/(sub_image.shape[0])

	return cumsum

def sharpness_all(run_name ,main_dir, image_list, image_list_length):

	outputFile= main_dir + '/' + run_name + '/' + 'sharpness.txt'

	content = ""

	for i in xrange(len(image_list_length)):
		image_current = image_list[i]
		line = str(i + 1) + " " + str(sharpness_detection_per_image(image_current)) + '\n'
		content += line

	if (not os.path.isfile(outputFile)):

		fsharpness = open(outputFile, "w")

		fsharpness.write(content)

		fsharpness.close()

	return

